<?php
$file = 'menu.json';
$versionFile = 'version.json';
$data = json_decode(file_get_contents($file), true);

function setByPath(&$array, $path, $value) {
    $keys = explode('|', $path);
    $ref =& $array;
    foreach ($keys as $k) {
        if (!isset($ref[$k])) return;
        $ref =& $ref[$k];
    }
    $ref = floatval($value);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['prices']) && is_array($_POST['prices'])) {
    foreach ($_POST['prices'] as $path => $val) {
        if ($val === '') continue;
        setByPath($data, $path, $val);
    }
    file_put_contents($file, json_encode($data, JSON_PRETTY_PRINT));

    // bump version so menu boards reload
    file_put_contents($versionFile, json_encode(['version' => time()]));

    $saved = true;
}

function renderFields($array, $prefix = []) {
    $html = '';
    foreach ($array as $key => $val) {
        $currentPath = array_merge($prefix, [$key]);
        if (is_array($val)) {
            $html .= renderFields($val, $currentPath);
        } else {
            if (is_numeric($val)) {
                $pathStr = implode('|', $currentPath);
                $labelParts = $currentPath;
                array_shift($labelParts); // drop top key (desserts, etc.)
                $label = end($labelParts); // just the item name like "Baklava"
                $html .= '<div class="row"><span class="item-name">' .
                         htmlspecialchars($label) .
                         '</span><span class="item-input"><input name="prices[' . htmlspecialchars($pathStr) .
                         ']" value="' . htmlspecialchars($val) .
                         '" /></span></div>';
            }
        }
    }
    return $html;
}
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Update Menu Prices</title>
    <style>
        * { box-sizing: border-box; }
        html, body {
            margin: 0;
            padding: 0;
            font-family: Arial, Helvetica, sans-serif;
            background: #f5f5f5;
            color: #222;
        }
        .wrapper {
            max-width: 1400px;
            margin: 40px auto 60px;
            background: #ffffff;
            padding: 40px 60px 60px;
            border-radius: 12px;
            box-shadow: 0 0 40px rgba(0,0,0,0.15);
        }
        h1 {
            font-size: 56px;
            color: #c32026;
            margin: 0 0 30px 0;
            text-transform: uppercase;
            letter-spacing: 0.08em;
        }
        h2 {
            font-size: 36px;
            color: #c32026;
            margin: 30px 0 10px 0;
        }
        .category {
            margin-bottom: 20px;
            border-top: 2px solid #eee;
            padding-top: 10px;
        }
        .row {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 6px 0;
            font-size: 20px;
        }
        .row:nth-child(odd) {
            background: #fafafa;
        }
        .item-name {
            flex: 1;
            padding-right: 20px;
        }
        .item-input input {
            width: 90px;
            font-size: 20px;
            padding: 4px 6px;
            text-align: right;
        }
        .save-bar {
            margin-top: 30px;
            padding-top: 16px;
            border-top: 2px solid #c32026;
            text-align: right;
        }
        button {
            font-size: 22px;
            padding: 10px 28px;
            background: #c32026;
            border: none;
            color: #fff;
            border-radius: 6px;
            cursor: pointer;
        }
        button:hover {
            background: #a11b20;
        }
        .saved {
            color: #1a7c2e;
            font-size: 20px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
<div class="wrapper">
    <h1>Update Menu Prices</h1>
    <?php if (!empty($saved)): ?>
        <div class="saved">Prices saved. Menu boards will refresh automatically.</div>
    <?php endif; ?>
    <form method="post">
        <?php foreach ($data as $topKey => $section): ?>
            <div class="category">
                <h2><?= htmlspecialchars(ucwords(str_replace('_', ' ', $topKey))) ?></h2>
                <?= renderFields($section, [$topKey]) ?>
            </div>
        <?php endforeach; ?>
        <div class="save-bar">
            <button type="submit">Save All Changes</button>
        </div>
    </form>
</div>
</body>
</html>
